<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('name', 'content', 'slug', 'image', 'categorie_id', 'user_id', 'online');
    protected $visible = array('name', 'content', 'slug', 'image', 'categorie_id', 'user_id');

    public function category()
    {
        return $this->hasOne('App\Model\Category');
    }

    public function user()
    {
        return $this->hasOne('App\Model\User');
    }

}